/****************************************************************************
* POLYTRAUMA DATABASE CHANGES - Feb. 2014 (PII)
* Summary of updates:

* - Change #1: DEF_35233 - PTRP - Residence (Discharge) DDL options are not displaying right options
****************************************************************************/

-- Change #1 for DEF_35233 - PTRP - Residence (Discharge) DDL options are not displaying right options
UPDATE [TBI].[STD_TBIDISCHARGETO] SET [NAME] = 'Military Housing (Apartment, Barracks or House)', [DESCRIPTION_TEXT] = 'Military Housing (Apartment, Barracks or House)' WHERE CODE = 'MTH'
UPDATE [TBI].[STD_TBIDISCHARGETO] SET [NAME] = 'Military Hospital (MTF)', [DESCRIPTION_TEXT] = 'Military Hospital (MTF)' WHERE CODE = 'MTF'

-- Change #2 for - DEF_35482 - PolyTrauma - Physical Assault should be directly above this section, set up as a drop down list in the same manner as Blast, Vehicle, Bullet, Other.
/************   Delete Physical Assault from TBIINJURYLIST table.   ************/
DELETE FROM [TBI].[STD_TBIINJURYLIST] WHERE [CODE] = 'Physical Assault';

-- add column for Physical Assault Injury
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PHYS_ASSAULT_INJRY_IND')
ALTER TABLE [TBI].[TBI_POLYTRAUMA] ADD [PHYS_ASSAULT_INJRY_IND] varchar(1) NULL
GO


-- Change #3 for DEF_35481 - Set Walter Reed and National Naval to inactive.
UPDATE [TBI].[STD_TBIFACILITYSRC] SET [INACTIVE_FLAG] = 1, [INACTIVE_DATE] = GETDATE() WHERE [ID] < 3;
GO


-- Change #4 for Task 35576 - Create Database change scripts for additional discharge scores and defects.
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_ABILITIES_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD [MPAI_ABILITIES_DC] int NULL

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_ADJUSTMENT_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD [MPAI_ADJUSTMENT_DC] int NULL

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_PARTICIPATION_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD [MPAI_PARTICIPATION_DC] int NULL

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_TOTAL_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD [MPAI_TOTAL_DC] int NULL

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'MPAI_Q26_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD [MPAI_Q26_DC] int NULL

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'SATIS_W_LIFE_DC')
ALTER TABLE TBI.TBI_POLYTRAUMA ADD [SATIS_W_LIFE_DC] int NULL


/************   Remove [TBI].[TBI_POLYTRAUMA].[PHYSICAL_ASSAULT_INJRY_IND] column   ************/
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'PHYSICAL_ASSAULT_INJRY_IND')
ALTER TABLE [TBI].[TBI_POLYTRAUMA] DROP COLUMN [PHYSICAL_ASSAULT_INJRY_IND];

GO

-- Change #5 - Remove Military Duty Status at Discharge (duplicate field)
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TBI_POLYTRAUMA' AND COLUMN_NAME = 'DC_MILITARY_DUTY_STATUS_ID')
BEGIN

ALTER TABLE TBI.TBI_POLYTRAUMA DROP CONSTRAINT FK_TBI_POLYTRAUMA_MILITARY_DUTY_STATUS_STD_TBIDSCHRGSTS

ALTER TABLE TBI.TBI_POLYTRAUMA DROP COLUMN DC_MILITARY_DUTY_STATUS_ID

END
GO